-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Waktu pembuatan: 22 Okt 2025 pada 07.34
-- Versi server: 10.4.32-MariaDB
-- Versi PHP: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `sistem_penilaian`
--

DELIMITER $$
--
-- Prosedur
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `generate_laporan_rapor` (IN `p_siswa_id` INT, IN `p_tahun_ajaran_id` INT)   BEGIN
    SELECT 
        vs.nama_siswa,
        vs.nis,
        vs.nama_kelas,
        vs.tingkat,
        vs.jurusan,
        vs.tahun_ajaran,
        vs.semester,
        vs.kode_mapel,
        vs.nama_mapel,
        vs.kode_tp,
        vs.deskripsi_tp,
        vs.jenis_penilaian,
        vs.nilai_formatif,
        vs.deskripsi_formatif,
        vs.nilai_sumatif,
        ROUND(AVG(vs.nilai_formatif) OVER (PARTITION BY vs.mapel_id), 2) as rata_rata_mapel_formatif,
        ROUND(AVG(vs.nilai_sumatif) OVER (PARTITION BY vs.mapel_id), 2) as rata_rata_mapel_sumatif
    FROM view_nilai_siswa vs
    WHERE vs.siswa_id = p_siswa_id 
    AND vs.tahun_ajaran_id = p_tahun_ajaran_id
    ORDER BY vs.kode_mapel, vs.kode_tp;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `pindah_kelas_siswa` (IN `p_siswa_id` INT, IN `p_kelas_baru_id` INT, IN `p_tahun_ajaran_id` INT, IN `p_semester` ENUM('ganjil','genap'), IN `p_user_id` INT)   BEGIN
    DECLARE current_kelas INT;
    DECLARE current_ta INT;
    
    -- Dapatkan kelas dan tahun ajaran saat ini
    SELECT kelas_id INTO current_kelas FROM siswa WHERE id = p_siswa_id;
    SELECT id INTO current_ta FROM tahun_ajaran WHERE status = 'aktif' LIMIT 1;
    
    -- Update kelas siswa
    UPDATE siswa 
    SET kelas_id = p_kelas_baru_id, 
        updated_at = CURRENT_TIMESTAMP
    WHERE id = p_siswa_id;
    
    -- Tambahkan ke riwayat kelas
    INSERT INTO riwayat_kelas (siswa_id, kelas_id, tahun_ajaran_id, semester)
    VALUES (p_siswa_id, p_kelas_baru_id, p_tahun_ajaran_id, p_semester);
    
    -- Log aktivitas
    INSERT INTO log_aktivitas (user_id, aksi, tabel_terkait, id_terkait, data_sebelum, data_sesudah)
    VALUES (p_user_id, 'PINDAH_KELAS', 'siswa', p_siswa_id, 
            CONCAT('kelas_id:', current_kelas, ',tahun_ajaran_id:', current_ta),
            CONCAT('kelas_id:', p_kelas_baru_id, ',tahun_ajaran_id:', p_tahun_ajaran_id));
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Struktur dari tabel `guru`
--

CREATE TABLE `guru` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `nip` varchar(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `guru`
--

INSERT INTO `guru` (`id`, `user_id`, `nip`) VALUES
(1, 4, '123345567'),
(2, 9, '199201182020121002'),
(4, 11, '12333232323');

-- --------------------------------------------------------

--
-- Struktur dari tabel `guru_mapel`
--

CREATE TABLE `guru_mapel` (
  `id` int(11) NOT NULL,
  `guru_id` int(11) DEFAULT NULL,
  `mapel_id` int(11) DEFAULT NULL,
  `kelas_id` int(11) DEFAULT NULL,
  `tahun_ajaran_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `created_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `guru_mapel`
--

INSERT INTO `guru_mapel` (`id`, `guru_id`, `mapel_id`, `kelas_id`, `tahun_ajaran_id`, `created_at`, `updated_at`, `created_by`) VALUES
(1, 1, 1, 1, 1, '2025-10-18 00:29:56', NULL, NULL),
(2, 2, 2, 9, 1, '2025-10-19 15:57:53', NULL, NULL),
(3, 2, 2, 2, 1, '2025-10-20 16:43:48', NULL, NULL),
(5, 4, 4, 1, 1, '2025-10-20 17:02:46', NULL, NULL),
(6, 4, 4, 2, 1, '2025-10-20 18:09:30', NULL, NULL),
(7, 2, 2, 1, 2, '2025-10-20 18:14:02', NULL, NULL);

-- --------------------------------------------------------

--
-- Struktur dari tabel `kelas`
--

CREATE TABLE `kelas` (
  `id` int(11) NOT NULL,
  `nama_kelas` varchar(20) NOT NULL,
  `tingkat` varchar(10) NOT NULL,
  `jurusan` varchar(50) DEFAULT 'Umum',
  `kapasitas` int(11) DEFAULT 32,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `kelas`
--

INSERT INTO `kelas` (`id`, `nama_kelas`, `tingkat`, `jurusan`, `kapasitas`, `created_at`) VALUES
(1, '7A', '9', 'Umum', 32, '2025-10-16 04:18:39'),
(2, '7B', '9', 'Umum', 32, '2025-10-16 04:20:48'),
(3, '8A', '9', 'Umum', 32, '2025-10-16 04:20:44'),
(4, '8B', '9', 'Umum', 32, '2025-10-16 04:21:35'),
(6, '9A', '9', '', 32, '2025-10-18 07:50:04'),
(7, '9B', '9', '', 40, '2025-10-18 07:58:56'),
(8, '7C', '9', '', 20, '2025-10-18 08:00:14'),
(9, '8C', '9', '', 32, '2025-10-18 08:29:53');

-- --------------------------------------------------------

--
-- Struktur dari tabel `log_aktivitas`
--

CREATE TABLE `log_aktivitas` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `aksi` varchar(100) NOT NULL,
  `tabel_terkait` varchar(50) NOT NULL,
  `id_terkait` int(11) DEFAULT NULL,
  `data_sebelum` text DEFAULT NULL,
  `data_sesudah` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `mata_pelajaran`
--

CREATE TABLE `mata_pelajaran` (
  `id` int(11) NOT NULL,
  `kode_mapel` varchar(10) NOT NULL,
  `nama_mapel` varchar(100) NOT NULL,
  `deskripsi` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `mata_pelajaran`
--

INSERT INTO `mata_pelajaran` (`id`, `kode_mapel`, `nama_mapel`, `deskripsi`, `created_at`) VALUES
(1, 'MTK', 'Matematika', '', '2025-10-16 04:17:03'),
(2, 'INF', 'Informatika', '', '2025-10-16 04:18:52'),
(3, 'BING', 'Bahasa Inggris', '', '2025-10-20 04:37:43'),
(4, 'PJOK', 'Pendidikan Jasmani dan Keolahragaan', '', '2025-10-20 17:02:11'),
(5, 'PKN', 'Pancasila', '', '2025-10-20 18:10:02');

-- --------------------------------------------------------

--
-- Struktur dari tabel `nilai_formatif`
--

CREATE TABLE `nilai_formatif` (
  `id` int(11) NOT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `siswa_id` int(11) DEFAULT NULL,
  `jenis` enum('observasi','tugas_tertulis','projek','portofolio','praktik','wawancara') NOT NULL,
  `nilai` decimal(5,2) NOT NULL,
  `deskripsi` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `nilai_formatif`
--

INSERT INTO `nilai_formatif` (`id`, `tp_id`, `siswa_id`, `jenis`, `nilai`, `deskripsi`, `created_at`, `updated_at`, `updated_by`) VALUES
(2, 1, 3, 'portofolio', 85.00, 'Melakukan apa', '2025-10-16 06:50:05', NULL, NULL),
(3, 1, 3, 'tugas_tertulis', 87.00, 'formatif ke 2', '2025-10-17 16:34:34', NULL, NULL),
(4, 1, 3, 'praktik', 77.00, 'formatif ke 3', '2025-10-17 16:35:18', NULL, NULL),
(5, 1, 4, 'observasi', 90.00, 'masuk', '2025-10-17 17:42:19', NULL, NULL),
(6, 1, 4, 'projek', 90.00, 'Bisa', '2025-10-17 17:42:42', NULL, NULL);

-- --------------------------------------------------------

--
-- Struktur dari tabel `nilai_sumatif`
--

CREATE TABLE `nilai_sumatif` (
  `id` int(11) NOT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `siswa_id` int(11) DEFAULT NULL,
  `nilai` decimal(5,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `nilai_sumatif`
--

INSERT INTO `nilai_sumatif` (`id`, `tp_id`, `siswa_id`, `nilai`, `created_at`, `updated_at`, `updated_by`) VALUES
(1, 1, 3, 70.00, '2025-10-16 06:49:07', NULL, NULL);

-- --------------------------------------------------------

--
-- Struktur dari tabel `riwayat_kelas`
--

CREATE TABLE `riwayat_kelas` (
  `id` int(11) NOT NULL,
  `siswa_id` int(11) NOT NULL,
  `kelas_id` int(11) NOT NULL,
  `tahun_ajaran_id` int(11) NOT NULL,
  `semester` enum('ganjil','genap') NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `riwayat_kelas`
--

INSERT INTO `riwayat_kelas` (`id`, `siswa_id`, `kelas_id`, `tahun_ajaran_id`, `semester`, `created_at`) VALUES
(1, 3, 1, 1, 'ganjil', '2025-10-18 00:34:07'),
(2, 4, 1, 1, 'ganjil', '2025-10-18 00:34:07'),
(3, 1, 4, 1, 'ganjil', '2025-10-18 00:34:07'),
(4, 2, 4, 1, 'ganjil', '2025-10-18 00:34:07'),
(15, 5, 4, 1, 'ganjil', '2025-10-18 08:20:36'),
(16, 6, 4, 1, 'ganjil', '2025-10-18 09:43:04');

-- --------------------------------------------------------

--
-- Struktur dari tabel `siswa`
--

CREATE TABLE `siswa` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `nis` varchar(20) NOT NULL,
  `kelas_id` int(11) DEFAULT NULL,
  `status` enum('aktif','pindah','lulus','dropout') DEFAULT 'aktif',
  `tanggal_mutasi` date DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `siswa`
--

INSERT INTO `siswa` (`id`, `user_id`, `nis`, `kelas_id`, `status`, `tanggal_mutasi`, `created_by`, `updated_at`) VALUES
(1, 2, '1001', 4, 'aktif', NULL, NULL, NULL),
(2, 3, '1002', 4, 'aktif', NULL, NULL, '2025-10-20 18:08:58'),
(3, 5, '2559', 1, 'aktif', NULL, NULL, '2025-10-18 10:00:26'),
(4, 6, '2562', 1, 'aktif', NULL, NULL, NULL),
(5, 7, '1003', 4, '', NULL, NULL, '2025-10-19 15:56:50'),
(6, 8, '1004', 4, '', NULL, NULL, '2025-10-18 09:43:14');

--
-- Trigger `siswa`
--
DELIMITER $$
CREATE TRIGGER `before_update_siswa` BEFORE UPDATE ON `siswa` FOR EACH ROW BEGIN
    SET NEW.updated_at = CURRENT_TIMESTAMP;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Struktur dari tabel `tahun_ajaran`
--

CREATE TABLE `tahun_ajaran` (
  `id` int(11) NOT NULL,
  `tahun_ajaran` varchar(20) NOT NULL,
  `semester` enum('ganjil','genap') NOT NULL,
  `status` enum('aktif','nonaktif') DEFAULT 'nonaktif',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `tahun_ajaran`
--

INSERT INTO `tahun_ajaran` (`id`, `tahun_ajaran`, `semester`, `status`, `created_at`) VALUES
(1, '2025/2026', 'ganjil', 'aktif', '2025-10-16 04:15:30'),
(2, '2025/2026', 'genap', 'nonaktif', '2025-10-17 18:25:47'),
(4, '2026/2027', 'ganjil', 'nonaktif', '2025-10-20 18:16:07');

-- --------------------------------------------------------

--
-- Struktur dari tabel `tujuan_pembelajaran`
--

CREATE TABLE `tujuan_pembelajaran` (
  `id` int(11) NOT NULL,
  `mapel_id` int(11) DEFAULT NULL,
  `tahun_ajaran_id` int(11) DEFAULT NULL,
  `kode_tp` varchar(20) NOT NULL,
  `deskripsi` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `tujuan_pembelajaran`
--

INSERT INTO `tujuan_pembelajaran` (`id`, `mapel_id`, `tahun_ajaran_id`, `kode_tp`, `deskripsi`, `created_at`) VALUES
(1, 1, 1, 'MTK7-TP1', 'Mampu mengopeasikan hitung penjumlahan bertingkat', '2025-10-16 04:33:18'),
(2, 1, 1, 'MTK7-TP2', 'Melakukan penerapan operasi hitung dalam kehidupan sehari-hari', '2025-10-16 06:53:14'),
(3, 1, 1, 'MTK7-TP3', 'Kelanjutan TP', '2025-10-17 16:32:45');

-- --------------------------------------------------------

--
-- Struktur dari tabel `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `level` enum('admin','guru','siswa') NOT NULL,
  `nama` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `users`
--

INSERT INTO `users` (`id`, `username`, `password`, `level`, `nama`, `created_at`) VALUES
(1, 'admin', '$2y$10$AetSe4prTrvDCY8TQ6GEzuSizQpYYh/1mvEz5FimzaOMBxeaPrD8e', 'admin', 'admin01', '0000-00-00 00:00:00'),
(2, '8B012024', '$2y$10$.qGVO1WqRnu1lI0h9Q40CuK65LqqEFl.dmejWX1IrfwWzBd/hQBHS', 'siswa', 'ADHENIA NAJWA AZZAHRA', '2025-10-16 04:24:25'),
(3, '8B022024', '$2y$10$j2kZ0WXzPq.5JqH4YFvTSOQ4qYNvKh70AMaX2zZfM3U.7qzVXDbxK', 'siswa', 'ADIB GALIH PANGESTU', '2025-10-16 04:24:57'),
(4, 'ninisctk', '$2y$10$2sJrCveTTW5tKKwCXh.5EOUgN2Vh5CX5WDhMYx9ubnB1aLBgBZibu', 'guru', 'NISWATUL ULFAH, S.Pd.', '2025-10-16 04:28:17'),
(5, '7A042025', '$2y$10$G96KFamcg/7nASQ8NTsGz.aU5f321OYToTkI9Qg21qRKXCb5cpH8C', 'siswa', 'ALYA IZZA DIEN HADI', '2025-10-16 04:31:08'),
(6, '7A072024', '$2y$10$r/ugaSvMRGDxFlLq3UyoL.0.w5T2A1iYR5uNYm/aPaP4YM0/L0.Ay', 'siswa', 'AULIA DESI SOIDA PUTRI', '2025-10-16 04:31:57'),
(7, 'siswa03', '$2y$10$dQGHkI3qcbGEVXV4wrWEouDhzC6XZ4ui6ZxdAUYrGbm2Xy2rrI7Ie', 'siswa', 'Siswa Abs 3s', '2025-10-18 08:20:36'),
(8, 'siswa3eqw', '$2y$10$Zjj1qo0r/CvAnCjG9q/1Z.CO/ipbRR0uYNKtImbrKZPf3lvMfWNnu', 'siswa', 'Abs 4', '2025-10-18 09:43:03'),
(9, 'ulinnuha', '$2y$10$w9QsyqaXy3UfRFQdzzdCQ.rtIgCO5oZNUbDpurK857WWpnHBB0mLe', 'guru', 'Muhammad Ulinnuha Musthofa, S.Pd.z', '2025-10-19 15:57:29'),
(11, 'pradan', '$2y$10$y1V.NNziy5fQADo1.ESOR.ooGfIX2UF30pFLpGY4SZwkG7rHEDbk2', 'guru', 'Pradanang Arif Wibowo, S.Pd.', '2025-10-20 16:56:41');

-- --------------------------------------------------------

--
-- Stand-in struktur untuk tampilan `view_monitoring_sistem`
-- (Lihat di bawah untuk tampilan aktual)
--
CREATE TABLE `view_monitoring_sistem` (
`tahun_ajaran` varchar(20)
,`semester` enum('ganjil','genap')
,`total_siswa` bigint(21)
,`total_guru` bigint(21)
,`total_kelas` bigint(21)
,`total_mapel` bigint(21)
,`total_tp` bigint(21)
,`total_nilai_formatif` bigint(21)
,`total_nilai_sumatif` bigint(21)
,`rata_rata_nilai_formatif` decimal(9,6)
,`rata_rata_nilai_sumatif` decimal(9,6)
);

-- --------------------------------------------------------

--
-- Stand-in struktur untuk tampilan `view_nilai_siswa`
-- (Lihat di bawah untuk tampilan aktual)
--
CREATE TABLE `view_nilai_siswa` (
`siswa_id` int(11)
,`nis` varchar(20)
,`user_id` int(11)
,`nama_siswa` varchar(100)
,`nama_kelas` varchar(20)
,`tingkat` varchar(10)
,`jurusan` varchar(50)
,`tahun_ajaran_id` int(11)
,`tahun_ajaran` varchar(20)
,`semester` enum('ganjil','genap')
,`tp_id` int(11)
,`kode_tp` varchar(20)
,`deskripsi_tp` text
,`mapel_id` int(11)
,`kode_mapel` varchar(10)
,`nama_mapel` varchar(100)
,`jenis_penilaian` enum('observasi','tugas_tertulis','projek','portofolio','praktik','wawancara')
,`nilai_formatif` decimal(5,2)
,`deskripsi_formatif` text
,`nilai_sumatif` decimal(5,2)
,`tgl_input_formatif` timestamp
,`tgl_input_sumatif` timestamp
);

-- --------------------------------------------------------

--
-- Stand-in struktur untuk tampilan `view_transkrip_siswa`
-- (Lihat di bawah untuk tampilan aktual)
--
CREATE TABLE `view_transkrip_siswa` (
`siswa_id` int(11)
,`nis` varchar(20)
,`nama_siswa` varchar(100)
,`tahun_ajaran` varchar(20)
,`semester` enum('ganjil','genap')
,`kode_mapel` varchar(10)
,`nama_mapel` varchar(100)
,`jumlah_tp` bigint(21)
,`rata_rata_formatif` decimal(6,2)
,`rata_rata_sumatif` decimal(6,2)
,`tgl_penilaian_terakhir` varchar(19)
);

-- --------------------------------------------------------

--
-- Struktur dari tabel `wali_kelas`
--

CREATE TABLE `wali_kelas` (
  `id` int(11) NOT NULL,
  `guru_id` int(11) NOT NULL,
  `kelas_id` int(11) NOT NULL,
  `tahun_ajaran_id` int(11) NOT NULL,
  `semester` enum('ganjil','genap') NOT NULL DEFAULT 'ganjil',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `created_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `wali_kelas`
--

INSERT INTO `wali_kelas` (`id`, `guru_id`, `kelas_id`, `tahun_ajaran_id`, `semester`, `created_at`, `updated_at`, `created_by`) VALUES
(1, 1, 1, 1, 'ganjil', '2025-10-20 18:08:30', NULL, 1),
(2, 2, 4, 1, 'ganjil', '2025-10-20 18:08:43', NULL, 1);

-- --------------------------------------------------------

--
-- Struktur untuk view `view_monitoring_sistem`
--
DROP TABLE IF EXISTS `view_monitoring_sistem`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_monitoring_sistem`  AS SELECT `ta`.`tahun_ajaran` AS `tahun_ajaran`, `ta`.`semester` AS `semester`, count(distinct `s`.`id`) AS `total_siswa`, count(distinct `g`.`id`) AS `total_guru`, count(distinct `k`.`id`) AS `total_kelas`, count(distinct `m`.`id`) AS `total_mapel`, count(distinct `tp`.`id`) AS `total_tp`, count(distinct `nf`.`id`) AS `total_nilai_formatif`, count(distinct `ns`.`id`) AS `total_nilai_sumatif`, avg(`nf`.`nilai`) AS `rata_rata_nilai_formatif`, avg(`ns`.`nilai`) AS `rata_rata_nilai_sumatif` FROM ((((((((`tahun_ajaran` `ta` left join `riwayat_kelas` `rk` on(`ta`.`id` = `rk`.`tahun_ajaran_id`)) left join `siswa` `s` on(`rk`.`siswa_id` = `s`.`id` and `s`.`status` = 'aktif')) left join `guru` `g` on(1 = 1)) left join `kelas` `k` on(1 = 1)) left join `mata_pelajaran` `m` on(1 = 1)) left join `tujuan_pembelajaran` `tp` on(`ta`.`id` = `tp`.`tahun_ajaran_id`)) left join `nilai_formatif` `nf` on(`tp`.`id` = `nf`.`tp_id`)) left join `nilai_sumatif` `ns` on(`tp`.`id` = `ns`.`tp_id`)) WHERE `ta`.`status` = 'aktif' GROUP BY `ta`.`id`, `ta`.`tahun_ajaran`, `ta`.`semester` ;

-- --------------------------------------------------------

--
-- Struktur untuk view `view_nilai_siswa`
--
DROP TABLE IF EXISTS `view_nilai_siswa`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_nilai_siswa`  AS SELECT `s`.`id` AS `siswa_id`, `s`.`nis` AS `nis`, `s`.`user_id` AS `user_id`, `u`.`nama` AS `nama_siswa`, `k`.`nama_kelas` AS `nama_kelas`, `k`.`tingkat` AS `tingkat`, `k`.`jurusan` AS `jurusan`, `ta`.`id` AS `tahun_ajaran_id`, `ta`.`tahun_ajaran` AS `tahun_ajaran`, `ta`.`semester` AS `semester`, `tp`.`id` AS `tp_id`, `tp`.`kode_tp` AS `kode_tp`, `tp`.`deskripsi` AS `deskripsi_tp`, `m`.`id` AS `mapel_id`, `m`.`kode_mapel` AS `kode_mapel`, `m`.`nama_mapel` AS `nama_mapel`, `nf`.`jenis` AS `jenis_penilaian`, `nf`.`nilai` AS `nilai_formatif`, `nf`.`deskripsi` AS `deskripsi_formatif`, `ns`.`nilai` AS `nilai_sumatif`, `nf`.`created_at` AS `tgl_input_formatif`, `ns`.`created_at` AS `tgl_input_sumatif` FROM (((((((((`siswa` `s` join `users` `u` on(`s`.`user_id` = `u`.`id`)) join `riwayat_kelas` `rk` on(`s`.`id` = `rk`.`siswa_id`)) join `tahun_ajaran` `ta` on(`rk`.`tahun_ajaran_id` = `ta`.`id` and `ta`.`status` = 'aktif')) join `kelas` `k` on(`rk`.`kelas_id` = `k`.`id`)) left join `guru_mapel` `gm` on(`gm`.`kelas_id` = `k`.`id` and `gm`.`tahun_ajaran_id` = `ta`.`id`)) left join `tujuan_pembelajaran` `tp` on(`tp`.`mapel_id` = `gm`.`mapel_id` and `tp`.`tahun_ajaran_id` = `ta`.`id`)) left join `mata_pelajaran` `m` on(`tp`.`mapel_id` = `m`.`id`)) left join `nilai_formatif` `nf` on(`tp`.`id` = `nf`.`tp_id` and `s`.`id` = `nf`.`siswa_id`)) left join `nilai_sumatif` `ns` on(`tp`.`id` = `ns`.`tp_id` and `s`.`id` = `ns`.`siswa_id`)) WHERE `s`.`status` = 'aktif' ;

-- --------------------------------------------------------

--
-- Struktur untuk view `view_transkrip_siswa`
--
DROP TABLE IF EXISTS `view_transkrip_siswa`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_transkrip_siswa`  AS SELECT `s`.`id` AS `siswa_id`, `s`.`nis` AS `nis`, `u`.`nama` AS `nama_siswa`, `ta`.`tahun_ajaran` AS `tahun_ajaran`, `ta`.`semester` AS `semester`, `m`.`kode_mapel` AS `kode_mapel`, `m`.`nama_mapel` AS `nama_mapel`, count(distinct `tp`.`id`) AS `jumlah_tp`, round(avg(`nf`.`nilai`),2) AS `rata_rata_formatif`, round(avg(`ns`.`nilai`),2) AS `rata_rata_sumatif`, max(greatest(coalesce(`nf`.`created_at`,0),coalesce(`ns`.`created_at`,0))) AS `tgl_penilaian_terakhir` FROM ((((((((`siswa` `s` join `users` `u` on(`s`.`user_id` = `u`.`id`)) join `riwayat_kelas` `rk` on(`s`.`id` = `rk`.`siswa_id`)) join `tahun_ajaran` `ta` on(`rk`.`tahun_ajaran_id` = `ta`.`id`)) join `guru_mapel` `gm` on(`gm`.`kelas_id` = `rk`.`kelas_id` and `gm`.`tahun_ajaran_id` = `ta`.`id`)) join `tujuan_pembelajaran` `tp` on(`tp`.`mapel_id` = `gm`.`mapel_id` and `tp`.`tahun_ajaran_id` = `ta`.`id`)) join `mata_pelajaran` `m` on(`tp`.`mapel_id` = `m`.`id`)) left join `nilai_formatif` `nf` on(`tp`.`id` = `nf`.`tp_id` and `s`.`id` = `nf`.`siswa_id`)) left join `nilai_sumatif` `ns` on(`tp`.`id` = `ns`.`tp_id` and `s`.`id` = `ns`.`siswa_id`)) WHERE `s`.`status` = 'aktif' GROUP BY `s`.`id`, `s`.`nis`, `u`.`nama`, `ta`.`tahun_ajaran`, `ta`.`semester`, `m`.`kode_mapel`, `m`.`nama_mapel` ;

--
-- Indexes for dumped tables
--

--
-- Indeks untuk tabel `guru`
--
ALTER TABLE `guru`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nip` (`nip`),
  ADD KEY `user_id` (`user_id`);

--
-- Indeks untuk tabel `guru_mapel`
--
ALTER TABLE `guru_mapel`
  ADD PRIMARY KEY (`id`),
  ADD KEY `mapel_id` (`mapel_id`),
  ADD KEY `tahun_ajaran_id` (`tahun_ajaran_id`),
  ADD KEY `kelas_id` (`kelas_id`),
  ADD KEY `idx_guru_mapel_composite` (`guru_id`,`mapel_id`,`kelas_id`,`tahun_ajaran_id`),
  ADD KEY `idx_guru_mapel_guru` (`guru_id`);

--
-- Indeks untuk tabel `kelas`
--
ALTER TABLE `kelas`
  ADD PRIMARY KEY (`id`);

--
-- Indeks untuk tabel `log_aktivitas`
--
ALTER TABLE `log_aktivitas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `tabel_terkait` (`tabel_terkait`),
  ADD KEY `created_at` (`created_at`);

--
-- Indeks untuk tabel `mata_pelajaran`
--
ALTER TABLE `mata_pelajaran`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kode_mapel` (`kode_mapel`);

--
-- Indeks untuk tabel `nilai_formatif`
--
ALTER TABLE `nilai_formatif`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_nilai_siswa_tp` (`siswa_id`,`tp_id`),
  ADD KEY `idx_nilai_tp_siswa` (`tp_id`,`siswa_id`);

--
-- Indeks untuk tabel `nilai_sumatif`
--
ALTER TABLE `nilai_sumatif`
  ADD PRIMARY KEY (`id`),
  ADD KEY `siswa_id` (`siswa_id`),
  ADD KEY `idx_nilai_sumatif_composite` (`tp_id`,`siswa_id`),
  ADD KEY `idx_nilai_sumatif_tp` (`tp_id`);

--
-- Indeks untuk tabel `riwayat_kelas`
--
ALTER TABLE `riwayat_kelas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `siswa_id` (`siswa_id`),
  ADD KEY `kelas_id` (`kelas_id`),
  ADD KEY `tahun_ajaran_id` (`tahun_ajaran_id`),
  ADD KEY `idx_siswa_tahun` (`siswa_id`,`tahun_ajaran_id`),
  ADD KEY `idx_riwayat_tahun` (`tahun_ajaran_id`);

--
-- Indeks untuk tabel `siswa`
--
ALTER TABLE `siswa`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nis` (`nis`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `kelas_id` (`kelas_id`),
  ADD KEY `idx_siswa_status` (`status`);

--
-- Indeks untuk tabel `tahun_ajaran`
--
ALTER TABLE `tahun_ajaran`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_ta_status` (`status`);

--
-- Indeks untuk tabel `tujuan_pembelajaran`
--
ALTER TABLE `tujuan_pembelajaran`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_tp_tahun_ajaran` (`tahun_ajaran_id`),
  ADD KEY `idx_tp_mapel_ta` (`mapel_id`,`tahun_ajaran_id`);

--
-- Indeks untuk tabel `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`);

--
-- Indeks untuk tabel `wali_kelas`
--
ALTER TABLE `wali_kelas`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_kelas_tahun_semester` (`kelas_id`,`tahun_ajaran_id`,`semester`),
  ADD KEY `guru_id` (`guru_id`),
  ADD KEY `tahun_ajaran_id` (`tahun_ajaran_id`),
  ADD KEY `created_by` (`created_by`);

--
-- AUTO_INCREMENT untuk tabel yang dibuang
--

--
-- AUTO_INCREMENT untuk tabel `guru`
--
ALTER TABLE `guru`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT untuk tabel `guru_mapel`
--
ALTER TABLE `guru_mapel`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT untuk tabel `kelas`
--
ALTER TABLE `kelas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT untuk tabel `log_aktivitas`
--
ALTER TABLE `log_aktivitas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT untuk tabel `mata_pelajaran`
--
ALTER TABLE `mata_pelajaran`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT untuk tabel `nilai_formatif`
--
ALTER TABLE `nilai_formatif`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT untuk tabel `nilai_sumatif`
--
ALTER TABLE `nilai_sumatif`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT untuk tabel `riwayat_kelas`
--
ALTER TABLE `riwayat_kelas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=28;

--
-- AUTO_INCREMENT untuk tabel `siswa`
--
ALTER TABLE `siswa`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT untuk tabel `tahun_ajaran`
--
ALTER TABLE `tahun_ajaran`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT untuk tabel `tujuan_pembelajaran`
--
ALTER TABLE `tujuan_pembelajaran`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT untuk tabel `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT untuk tabel `wali_kelas`
--
ALTER TABLE `wali_kelas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- Ketidakleluasaan untuk tabel pelimpahan (Dumped Tables)
--

--
-- Ketidakleluasaan untuk tabel `guru`
--
ALTER TABLE `guru`
  ADD CONSTRAINT `guru_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Ketidakleluasaan untuk tabel `guru_mapel`
--
ALTER TABLE `guru_mapel`
  ADD CONSTRAINT `guru_mapel_ibfk_1` FOREIGN KEY (`guru_id`) REFERENCES `guru` (`id`),
  ADD CONSTRAINT `guru_mapel_ibfk_2` FOREIGN KEY (`mapel_id`) REFERENCES `mata_pelajaran` (`id`),
  ADD CONSTRAINT `guru_mapel_ibfk_3` FOREIGN KEY (`tahun_ajaran_id`) REFERENCES `tahun_ajaran` (`id`),
  ADD CONSTRAINT `guru_mapel_ibfk_4` FOREIGN KEY (`kelas_id`) REFERENCES `kelas` (`id`);

--
-- Ketidakleluasaan untuk tabel `log_aktivitas`
--
ALTER TABLE `log_aktivitas`
  ADD CONSTRAINT `log_aktivitas_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Ketidakleluasaan untuk tabel `nilai_formatif`
--
ALTER TABLE `nilai_formatif`
  ADD CONSTRAINT `nilai_formatif_ibfk_1` FOREIGN KEY (`tp_id`) REFERENCES `tujuan_pembelajaran` (`id`),
  ADD CONSTRAINT `nilai_formatif_ibfk_2` FOREIGN KEY (`siswa_id`) REFERENCES `siswa` (`id`);

--
-- Ketidakleluasaan untuk tabel `nilai_sumatif`
--
ALTER TABLE `nilai_sumatif`
  ADD CONSTRAINT `nilai_sumatif_ibfk_1` FOREIGN KEY (`tp_id`) REFERENCES `tujuan_pembelajaran` (`id`),
  ADD CONSTRAINT `nilai_sumatif_ibfk_2` FOREIGN KEY (`siswa_id`) REFERENCES `siswa` (`id`);

--
-- Ketidakleluasaan untuk tabel `siswa`
--
ALTER TABLE `siswa`
  ADD CONSTRAINT `siswa_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `siswa_ibfk_2` FOREIGN KEY (`kelas_id`) REFERENCES `kelas` (`id`);

--
-- Ketidakleluasaan untuk tabel `tujuan_pembelajaran`
--
ALTER TABLE `tujuan_pembelajaran`
  ADD CONSTRAINT `fk_tp_mapel` FOREIGN KEY (`mapel_id`) REFERENCES `mata_pelajaran` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_tp_tahun_ajaran` FOREIGN KEY (`tahun_ajaran_id`) REFERENCES `tahun_ajaran` (`id`) ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `wali_kelas`
--
ALTER TABLE `wali_kelas`
  ADD CONSTRAINT `wali_kelas_ibfk_1` FOREIGN KEY (`guru_id`) REFERENCES `guru` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `wali_kelas_ibfk_2` FOREIGN KEY (`kelas_id`) REFERENCES `kelas` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `wali_kelas_ibfk_3` FOREIGN KEY (`tahun_ajaran_id`) REFERENCES `tahun_ajaran` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `wali_kelas_ibfk_4` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
